/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thebeyond;

import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.helpers.CardHelper;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.vfx.cardManip.PurgeCardEffect;

public class Falling
extends AbstractImageEvent {
    public static final String ID = "Falling";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Falling");
    public static final String NAME = Falling.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = Falling.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = Falling.eventStrings.OPTIONS;
    private static final String DIALOG_1 = DESCRIPTIONS[0];
    private static final String DIALOG_2 = DESCRIPTIONS[1];
    private CurScreen screen = CurScreen.INTRO;
    private boolean attack;
    private boolean skill;
    private boolean power;
    private AbstractCard attackCard;
    private AbstractCard skillCard;
    private AbstractCard powerCard;

    public Falling() {
        super(NAME, DIALOG_1, "images/events/falling.jpg");
        this.setCards();
        GenericEventDialog.setDialogOption(OPTIONS[0]);
    }

    private void setCards() {
        this.attack = CardHelper.hasCardWithType(AbstractCard.CardType.ATTACK);
        this.skill = CardHelper.hasCardWithType(AbstractCard.CardType.SKILL);
        this.power = CardHelper.hasCardWithType(AbstractCard.CardType.POWER);
        if (this.attack) {
            this.attackCard = CardHelper.returnCardOfType(AbstractCard.CardType.ATTACK);
        }
        if (this.skill) {
            this.skillCard = CardHelper.returnCardOfType(AbstractCard.CardType.SKILL);
        }
        if (this.power) {
            this.powerCard = CardHelper.returnCardOfType(AbstractCard.CardType.POWER);
        }
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        switch (this.screen) {
            case INTRO: {
                this.screen = CurScreen.CHOICE;
                GenericEventDialog.updateBodyText(DIALOG_2);
                GenericEventDialog.clearAllDialogs();
                if (this.skill) {
                    GenericEventDialog.setDialogOption(OPTIONS[1] + FontHelper.colorString(this.skillCard.name, "r"));
                } else {
                    GenericEventDialog.setDialogOption(OPTIONS[2], true);
                }
                if (this.power) {
                    GenericEventDialog.setDialogOption(OPTIONS[3] + FontHelper.colorString(this.powerCard.name, "r"));
                } else {
                    GenericEventDialog.setDialogOption(OPTIONS[4], true);
                }
                if (this.attack) {
                    GenericEventDialog.setDialogOption(OPTIONS[5] + FontHelper.colorString(this.attackCard.name, "r"));
                    break;
                }
                GenericEventDialog.setDialogOption(OPTIONS[6], true);
                break;
            }
            case CHOICE: {
                this.screen = CurScreen.RESULT;
                GenericEventDialog.clearAllDialogs();
                GenericEventDialog.setDialogOption(OPTIONS[7]);
                switch (buttonPressed) {
                    case 0: {
                        GenericEventDialog.updateBodyText(DESCRIPTIONS[2]);
                        AbstractDungeon.effectList.add(new PurgeCardEffect(this.skillCard));
                        AbstractDungeon.player.masterDeck.removeCard(this.skillCard);
                        break;
                    }
                    case 1: {
                        GenericEventDialog.updateBodyText(DESCRIPTIONS[3]);
                        AbstractDungeon.effectList.add(new PurgeCardEffect(this.powerCard));
                        AbstractDungeon.player.masterDeck.removeCard(this.powerCard);
                        break;
                    }
                    case 2: {
                        GenericEventDialog.updateBodyText(DESCRIPTIONS[4]);
                        AbstractDungeon.effectList.add(new PurgeCardEffect(this.attackCard));
                        AbstractDungeon.player.masterDeck.removeCard(this.attackCard);
                    }
                }
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(ID, actionTaken);
    }

    private static enum CurScreen {
        INTRO,
        CHOICE,
        RESULT;

    }
}

